/************************************************************/
/* PROJECT NAME: Thumb	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin       tmartin@hitex.co.uk         */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V2.00b		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2005						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* 										         			*/
/*															*/
/* Demonstrates edge capture with Timer 0					*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/

#include <LPC21xx.H> 

void T0isr(void)	__irq;


int main(void)
{
VPBDIV		= 0x00000002;					//Set pclk to 30 Mhz
PINSEL0 	= ;								//Enable pin 0.2 as capture channel0
T0PR 		= ;								//Load prescaler for 1 Msec tick
T0TCR 		= ;								//Reset counter and prescaler
T0CCR 		= 0x00000005;					//Capture on rising edge of channel0
T0TCR 		= ;								//enable timer

VICVectAddr4 = (unsigned)T0isr; 			//Set the timer ISR vector address
VICVectCntl4 = 0x00000024;					//Set channel
VICIntEnable = 0x00000010;					//Enable the interrupt

while(1)
{
;
}
}


void T0isr (void)	__irq
{
static int value;
value		 = ;							// read the capture value
T0IR 		|= 0x00000001;					//Clear match 0 interrupt
VICVectAddr  = 0x00000000;					//Dummy write to signal end of interrupt
								   	
}


